# 🟣 Ocampo Klever — Landing Page Canva Pro

Landing page premium **Dark Luxury** para la venta y activación de Canva Pro por WhatsApp.

---

## 📁 Estructura del Proyecto

```
Web canva/
├── index.html        ← Página principal
├── styles.css        ← Estilos (Dark Luxury + Glow Neón)
├── script.js         ← Interactividad (partículas, flip cards, FAQ, counters)
├── README.md         ← Este archivo
└── images/
    ├── logo.png          ← Logo Ocampo Klever
    ├── hero_visual.png   ← Visual principal del hero
    ├── service_1.png     ← Plantillas Premium
    ├── service_2.png     ← Background Remover
    ├── service_3.png     ← Magic Resize
    ├── service_4.png     ← Brand Kit
    ├── service_5.png     ← Contenido Redes
    └── service_6.png     ← Activación + Soporte
```

---

## 📲 Cómo cambiar el número de WhatsApp

Abre `script.js` y cambia la **línea 4**:

```javascript
const WHATSAPP_NUMBER = '593960705007'; // +593 96 070 5007
```

**Formato:** Código de país + número sin espacios ni guiones.
- Ecuador: `593999123456`
- Colombia: `57300123456`
- México: `5215512345678`

---

## 🎨 Paleta de Colores

| Token               | Color     | Uso                         |
|---------------------|-----------|-----------------------------|
| `--bg-primary`      | `#000000` | Fondo principal             |
| `--bg-secondary`    | `#09090B` | Fondo alterno secciones     |
| `--bg-tertiary`     | `#18181B` | Cards / componentes         |
| `--text-primary`    | `#FFFFFF` | Texto principal             |
| `--text-secondary`  | `#E4E4E7` | Texto secundario            |
| `--text-tertiary`   | `#A1A1AA` | Texto terciario             |
| `--primary-500`     | `#A855F7` | Color principal púrpura     |
| `--primary-400`     | `#C084FC` | Acento claro                |
| `--primary-600`     | `#9333EA` | Acento oscuro               |

### Cambiar el color principal

En `styles.css`, busca el bloque `:root` y modifica las variables `--primary-*`. Ajusta también los `rgba()` de los glows.

---

## 🖼️ Imágenes Generadas

| Archivo             | Descripción                                      |
|---------------------|--------------------------------------------------|
| `logo.png`          | Logo "OK" minimalista con glow púrpura           |
| `hero_visual.png`   | Visual premium 3D con formas abstractas          |
| `service_1.png`     | Plantillas premium ilimitadas                    |
| `service_2.png`     | Background Remover (quitar fondo 1 clic)         |
| `service_3.png`     | Magic Resize (redimensionado mágico)             |
| `service_4.png`     | Brand Kit (kit de marca)                         |
| `service_5.png`     | Contenido para redes (posts/reels/historias)     |
| `service_6.png`     | Activación segura + soporte WhatsApp             |

> **Nota:** Las imágenes service_3 a service_6 usan placeholders con gradiente + emoji. Reemplaza los archivos en `/images/` cuando estén disponibles.

---

## 🚀 Cómo Publicar

### Opción 1: Netlify (Recomendado)
1. Ve a [netlify.com](https://netlify.com) y crea una cuenta
2. Arrastra la carpeta `Web canva` completa al área de deploy
3. ¡Listo! Obtén tu URL automáticamente

### Opción 2: Vercel
1. Ve a [vercel.com](https://vercel.com)
2. Importa el proyecto o arrastra los archivos
3. Publica con un clic

### Opción 3: GitHub Pages
1. Sube los archivos a un repositorio de GitHub
2. Ve a Settings → Pages → Source: main branch
3. Tu sitio estará en `https://tuusuario.github.io/tu-repo`

### Opción 4: Hosting propio
Simplemente sube todos los archivos al directorio público de tu hosting (`public_html` o similar).

---

## ✅ Checklist Final

- [x] Oferta visible: $5 / 1 año — $8 / 2 años
- [x] "Activa primero y luego pagas" aparece 3+ veces
- [x] CTA WhatsApp 5+ veces + botón flotante
- [x] Sin formularios (0 inputs)
- [x] FAQ con 6 preguntas y respuestas
- [x] Flip cards funcionan mobile/desktop
- [x] Dark luxury + glow púrpura consistente
- [x] 100% responsive
- [x] Listo para publicar

---

**Creado con 💜 por Ocampo Klever**
